<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package lesbonstech
 */

if (strpos($_SERVER['REQUEST_URI'], "en") !== false){
    $title = "Error 404";
    $text = "The page you are looking for does not exist.";
    $btn = "Back to home";
} else {
    $title = "Erreur 404";
    $text = "La page que vous recherchez n'existe pas.";
    $btn = "Retour à l'accueil";
}
?>
<head>
    <link rel="stylesheet" href="/wp-content/themes/lesbonstech/style.css" type="text/css" media="all">
</head>
<main id="notfound">
    <section id="error">
        <div class="wrapper">
            <h1 class="title"><?= $title ?></h1>
            <p class="text"><?= $text ?></p>
            <a href="<?php echo get_home_url(); ?>" class="btn"><?= $btn ?></a>
        </div>
    </section>
</main>