<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package lesbonstech
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <title>Castmetal</title>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<header id="masthead" class="site-header">
        <div class="container">
            <div class="col">
                <div class="logo">
                    <a href="/">
                        <?php the_custom_logo(); ?>
                    </a>
                </div>
            </div>
            <div class="col">
                <div class="topbar desktop">
                    <div class="language">
                        <?php pll_the_languages(array('show_flags'=>1,'hide_current'=>1));?>
                    </div>
                    <div class="social">
                        <a id="linkedin" href="https://www.linkedin.com/company/safemetal/">
                            <svg id="Groupe_103" data-name="Groupe 103" xmlns="http://www.w3.org/2000/svg" width="11.087" height="11.087" viewBox="0 0 11.087 11.087">
                                <g id="linkedin" transform="translate(0)">
                                    <path id="Tracé_5" data-name="Tracé 5" d="M14.237,13.9h0V9.833c0-1.989-.428-3.522-2.754-3.522a2.414,2.414,0,0,0-2.174,1.2H9.279V6.5h-2.2v7.4h2.3V10.234c0-.965.183-1.9,1.378-1.9,1.178,0,1.2,1.1,1.2,1.96v3.6Z" transform="translate(-3.153 -2.813)" fill="#fff"/>
                                    <path id="Tracé_6" data-name="Tracé 6" d="M.33,6.647h2.3v7.4H.33Z" transform="translate(-0.147 -2.962)" fill="#fff"/>
                                    <path id="Tracé_7" data-name="Tracé 7" d="M1.331,0A1.338,1.338,0,1,0,2.663,1.331,1.332,1.332,0,0,0,1.331,0Z" fill="#fff"/>
                                </g>
                            </svg>
                        </a>
                    </div>
                </div>
                <div class="menu-mobile mobile">
                    <input class="menu-btn" type="checkbox" id="menu-btn" onclick="addClassIfChecked()" />
                    <label class="menu-icon" for="menu-btn"><span class="navicon"></span></label>
                    <div class="mega-menu">
                        <div class="topbar">
                            <div class="language">
                                <?php pll_the_languages(array('show_flags'=>1,'hide_current'=>1));?>
                            </div>
                            <div class="social">
                                <a id="linkedin" href="#">
                                    <svg id="Groupe_103" data-name="Groupe 103" xmlns="http://www.w3.org/2000/svg" width="11.087" height="11.087" viewBox="0 0 11.087 11.087">
                                        <g id="linkedin" transform="translate(0)">
                                            <path id="Tracé_5" data-name="Tracé 5" d="M14.237,13.9h0V9.833c0-1.989-.428-3.522-2.754-3.522a2.414,2.414,0,0,0-2.174,1.2H9.279V6.5h-2.2v7.4h2.3V10.234c0-.965.183-1.9,1.378-1.9,1.178,0,1.2,1.1,1.2,1.96v3.6Z" transform="translate(-3.153 -2.813)" fill="#fff"/>
                                            <path id="Tracé_6" data-name="Tracé 6" d="M.33,6.647h2.3v7.4H.33Z" transform="translate(-0.147 -2.962)" fill="#fff"/>
                                            <path id="Tracé_7" data-name="Tracé 7" d="M1.331,0A1.338,1.338,0,1,0,2.663,1.331,1.332,1.332,0,0,0,1.331,0Z" fill="#fff"/>
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <?php wp_nav_menu( array('theme_location' => 'header-menu') ); ?>
                        <div class="botbar">
                            <div class="border"></div>
                            <div class="contact-link">
                                <?php
                                    if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){
                                        ?>
                                        <a href="<?= the_permalink(860) ?>">
                                            Contact us
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                                                <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                                                    <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                                    <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                                    <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                                </g>
                                            </svg>
                                        </a>
                                        <?php
                                    } else {
                                        ?>
                                        <a href="<?= the_permalink(187) ?>">
                                            Contactez-nous
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                                                <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                                                    <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                                    <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                                    <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                                </g>
                                            </svg>
                                        </a>
                                        <?php
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <nav class="navbar desktop">
                    <?php wp_nav_menu( array('theme_location' => 'header-menu') ); ?>
                    <div class="contact-link">
                        <?php
                            if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){
                                ?>
                                <a href="<?= the_permalink(860) ?>">Contact us</a>
                                <?php
                            } else {
                                ?>
                                <a href="<?= the_permalink(187) ?>">Contactez-nous</a>
                                <?php
                            }
                        ?>
                    </div>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                    <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                        <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                    </g>
                    </svg>
                </nav>
            </div>
        </div>
	</header><!-- #masthead -->
    <?php
        if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){
            ?>
            <div id="en" class="lateral-btn desktop">
                <a href="/contact-us">Challenge us</a>
            </div>
            <?php
        } else {
            ?>
            <div id="fr" class="lateral-btn desktop">
                <a href="/contact">Venez nous challenger</a>
            </div>
            <?php
        }
    ?>