<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Castmetal
 */

get_header();
?>
<div class="single-article">
    <div class="landing">
        <img src="/wp-content/uploads/2023/04/filtre-blanc.png" alt="" class="filter">
        <div class="container">
            <?php 
                $tag = wp_get_post_terms( get_the_ID(), "category" )[0];
            ?>
            <div class="col" style="width: 65%;">
                <div class="btn reverse">
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                        <a href="/news">
                            Back to blog
                            <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                                <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                                    <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                    <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                    <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                </g>
                            </svg>
                        </a>
                    <?php } else { ?>
                        <a href="/actualites">
                            Retour au blog
                            <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                                <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                                    <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                    <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                    <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                </g>
                            </svg>
                        </a>
                        <?php } ?> 
                </div>
                <br>
                <h1 class="text-blanc"><?= the_title() ?></h1>
                <div class="info">
                    <div class="tags">
                        <span><?= str_replace( ' ', '', $tag->name ); ?></span>
                    </div>
                    <div class="date">
                        <svg id="Groupe_86" data-name="Groupe 86" xmlns="http://www.w3.org/2000/svg" width="13" height="13" viewBox="0 0 13 13">
                            <g id="calendar_copie" data-name="calendar copie">
                                <g id="Groupe_57" data-name="Groupe 57">
                                <g id="Groupe_56" data-name="Groupe 56">
                                    <path id="Tracé_62" data-name="Tracé 62" d="M11.477,1.016h-.609V0H9.852V1.016h-6.7V0H2.133V1.016H1.523A1.525,1.525,0,0,0,0,2.539v8.938A1.525,1.525,0,0,0,1.523,13h9.953A1.525,1.525,0,0,0,13,11.477V2.539A1.525,1.525,0,0,0,11.477,1.016Zm.508,10.461a.508.508,0,0,1-.508.508H1.523a.508.508,0,0,1-.508-.508v-6.7H11.984Zm0-7.719H1.016V2.539a.508.508,0,0,1,.508-.508h.609V3.047H3.148V2.031h6.7V3.047h1.016V2.031h.609a.508.508,0,0,1,.508.508Z" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_59" data-name="Groupe 59" transform="translate(1.93 5.84)">
                                <g id="Groupe_58" data-name="Groupe 58">
                                    <rect id="Rectangle_46" data-name="Rectangle 46" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_61" data-name="Groupe 61" transform="translate(3.961 5.84)">
                                <g id="Groupe_60" data-name="Groupe 60">
                                    <rect id="Rectangle_47" data-name="Rectangle 47" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_63" data-name="Groupe 63" transform="translate(5.992 5.84)">
                                <g id="Groupe_62" data-name="Groupe 62">
                                    <rect id="Rectangle_48" data-name="Rectangle 48" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_65" data-name="Groupe 65" transform="translate(8.023 5.84)">
                                <g id="Groupe_64" data-name="Groupe 64">
                                    <rect id="Rectangle_49" data-name="Rectangle 49" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_67" data-name="Groupe 67" transform="translate(10.055 5.84)">
                                <g id="Groupe_66" data-name="Groupe 66">
                                    <rect id="Rectangle_50" data-name="Rectangle 50" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_69" data-name="Groupe 69" transform="translate(1.93 7.871)">
                                <g id="Groupe_68" data-name="Groupe 68">
                                    <rect id="Rectangle_51" data-name="Rectangle 51" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_71" data-name="Groupe 71" transform="translate(3.961 7.871)">
                                <g id="Groupe_70" data-name="Groupe 70">
                                    <rect id="Rectangle_52" data-name="Rectangle 52" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_73" data-name="Groupe 73" transform="translate(5.992 7.871)">
                                <g id="Groupe_72" data-name="Groupe 72">
                                    <rect id="Rectangle_53" data-name="Rectangle 53" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_75" data-name="Groupe 75" transform="translate(8.023 7.871)">
                                <g id="Groupe_74" data-name="Groupe 74">
                                    <rect id="Rectangle_54" data-name="Rectangle 54" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_77" data-name="Groupe 77" transform="translate(1.93 9.902)">
                                <g id="Groupe_76" data-name="Groupe 76">
                                    <rect id="Rectangle_55" data-name="Rectangle 55" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_79" data-name="Groupe 79" transform="translate(3.961 9.902)">
                                <g id="Groupe_78" data-name="Groupe 78">
                                    <rect id="Rectangle_56" data-name="Rectangle 56" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_81" data-name="Groupe 81" transform="translate(5.992 9.902)">
                                <g id="Groupe_80" data-name="Groupe 80">
                                    <rect id="Rectangle_57" data-name="Rectangle 57" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_83" data-name="Groupe 83" transform="translate(8.023 9.902)">
                                <g id="Groupe_82" data-name="Groupe 82">
                                    <rect id="Rectangle_58" data-name="Rectangle 58" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                                <g id="Groupe_85" data-name="Groupe 85" transform="translate(10.055 7.871)">
                                <g id="Groupe_84" data-name="Groupe 84">
                                    <rect id="Rectangle_59" data-name="Rectangle 59" width="1.016" height="1.016" fill="#fff"/>
                                </g>
                                </g>
                            </g>
                        </svg>
                        <?= get_the_date("j F Y") ?>
                    </div>
                    <div class="read-time">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16.5" height="16.5" viewBox="0 0 16.5 16.5">
                            <g id="Icon_feather-clock" data-name="Icon feather-clock" transform="translate(0.75 0.75)">
                                <path id="Tracé_76" data-name="Tracé 76" d="M18,10.5A7.5,7.5,0,1,1,10.5,3,7.5,7.5,0,0,1,18,10.5Z" transform="translate(-3 -3)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <path id="Tracé_77" data-name="Tracé 77" d="M18,9v4.757l3.172,1.586" transform="translate(-10.607 -6.114)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                            </g>
                        </svg>
                        <?= get_field('read_time') ?>
                    </div>
               </div>
            </div>
            <div class="col">
                <div class="image">
                    <img src="<?= get_the_post_thumbnail_url() ?>" alt="<?= the_post_thumbnail_caption() ?>">
                </div>
            </div>
            <div class="reading">
                <p class="text-blanc">
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                        Read the article
                    <?php } else { ?>
                        Lire l'article
                    <?php } ?>
                </p>
                <svg xmlns="http://www.w3.org/2000/svg" width="13.992" height="8" viewBox="0 0 13.992 8">
                    <path id="Icon_ionic-ios-arrow-down" data-name="Icon ionic-ios-arrow-down" d="M13.186,16.835l5.291-5.295a1,1,0,0,1,1.412,0,1.008,1.008,0,0,1,0,1.416l-5.995,6a1,1,0,0,1-1.379.029L6.479,12.961a1,1,0,0,1,1.412-1.416Z" transform="translate(-6.188 -11.246)" fill="#fff"/>
                </svg>
            </div>
        </div>
    </div><!-- landing -->
    <div class="builder">
        <div class="container">
            <?php
                // Check value exists.
                if (have_rows('builder')) :

                    // Loop through rows.
                    while (have_rows('builder')) : the_row();

                        // Case: Paragraph layout.
                        if (get_row_layout() == 'title_text') :
                            get_template_part("template-parts/partials/title_text");
                        endif;

                        if (get_row_layout() == 'title_text_btn') :
                            get_template_part("template-parts/partials/title_text_btn");
                        endif;

                        if (get_row_layout() == 'text_img') :
                            get_template_part("template-parts/partials/text_img");
                        endif;

                        if (get_row_layout() == 'slider') :
                            get_template_part("template-parts/partials/slider");
                        endif;

                    // End loop.
                    endwhile;

                // No value.
                else :
                // Do something...
                endif;
            ?>
            <div class="end-article">
                <div class="share">
                    <a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" width="38" height="38" viewBox="0 0 38 38">
                            <g id="Groupe_351" data-name="Groupe 351" transform="translate(-150 -2332)">
                                <rect id="Rectangle_129" data-name="Rectangle 129" width="38" height="38" rx="18" transform="translate(150 2332)" fill="#bc965c"/>
                                <g id="Groupe_177" data-name="Groupe 177" transform="translate(160 2339)">
                                <g id="linkedin" transform="translate(0 1)">
                                    <path id="Tracé_5" data-name="Tracé 5" d="M19.995,20H20V12.664c0-3.588-.772-6.352-4.967-6.352A4.355,4.355,0,0,0,11.11,8.467h-.058V6.647H7.074V20h4.142V13.387c0-1.741.33-3.424,2.486-3.424,2.124,0,2.156,1.987,2.156,3.536V20Z" fill="#0c1f40"/>
                                    <path id="Tracé_6" data-name="Tracé 6" d="M.33,6.647H4.477V20H.33Z" fill="#0c1f40"/>
                                    <path id="Tracé_7" data-name="Tracé 7" d="M2.4,0A2.413,2.413,0,1,0,4.8,2.4,2.4,2.4,0,0,0,2.4,0Z" fill="#0c1f40"/>
                                </g>
                                </g>
                            </g>
                        </svg>
                    </a>
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                        Share the article
                    <?php } else { ?>
                        Partager l'article
                    <?php } ?>
                </div>
                <div class="navigation">
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){
                        $previous = 'Previous article';
                        $next = 'Next article';
                    } else {
                        $previous = 'Article précédent';
                        $next = 'Article suivant';
                    } ?>
                    <div class="previous">
                        <?php previous_post_link('%link', '<svg xmlns="http://www.w3.org/2000/svg" width="18.207" height="7.428" viewBox="0 0 18.207 7.428"><g id="Groupe_138" data-name="Groupe 138" transform="translate(0.5 0.707)"><line id="Ligne_1" data-name="Ligne 1" x2="17" transform="translate(0 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/><line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(13.993)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/><line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(13.993 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/></g></svg>'. $previous); ?>
                        
                    </div>
                    <div class="next">
                        <?php next_post_link('%link', '<svg xmlns="http://www.w3.org/2000/svg" width="18.207" height="7.428" viewBox="0 0 18.207 7.428"><g id="Groupe_138" data-name="Groupe 138" transform="translate(0.5 0.707)"><line id="Ligne_1" data-name="Ligne 1" x2="17" transform="translate(0 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/><line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(13.993)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/><line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(13.993 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/></g></svg>'. $next); ?>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="article-lie">
        <?php
        $article = get_field('articles_lie');
        $article_1 = $article['1'];
        $article_2 = $article['2'];
        $article_3 = $article['3'];
        ?>
        <div class="container">
            <span class="mini_title">
                <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    Also read
                <?php } else { ?>
                    Lire aussi
                <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2><?= $article['title'] ?></h2>
            <div class="articles">
                <!-- Article 1 -->
                <a href="<?= the_permalink($article_1) ?>" class="card">
                    <div class="image">
                        <img src="<?= get_the_post_thumbnail_url($article_1) ?>" alt="<?= the_post_thumbnail_caption($article_1) ?>">
                        <?php
                        $term = wp_get_post_terms( $article_1->ID, "category" )[0];
                        ?>
                        <div class="tag"><?= str_replace( ' ', '', $term->name ); ?></div>
                    </div>
                    <div class="content">
                        <h3 class="title"><?= get_the_title($article_1->ID) ?></h3>
                        <p class="author"><?= get_the_author_meta('display_name', $article_1->post_author) ?></p>
                        <p class="text"><?= get_the_excerpt($article_1->ID) ?></p>
                        <span class="date"><?= get_the_date( "d/m/Y", $article_1 ) ?></span>
                    </div>
                </a>
                <!-- Article 2 -->
                <a href="<?= the_permalink($article_2) ?>" class="card">
                    <div class="image">
                        <img src="<?= get_the_post_thumbnail_url($article_2) ?>" alt="<?= the_post_thumbnail_caption($article_2) ?>">
                        <?php
                        $term = wp_get_post_terms( $article_2->ID, "category" )[0];
                        ?>
                        <div class="tag"><?= str_replace( ' ', '', $term->name ); ?></div>
                    </div>
                    <div class="content">
                        <h3 class="title"><?= get_the_title($article_2->ID) ?></h3>
                        <p class="author"><?= get_the_author_meta('display_name', $article_2->post_author) ?></p>
                        <p class="text"><?= get_the_excerpt($article_2->ID) ?></p>
                        <span class="date"><?= get_the_date( "d/m/Y", $article_2 ) ?></span>
                    </div>
                </a>
                <!-- Article 3 -->
                <a href="<?= the_permalink($article_3) ?>" class="card">
                    <div class="image">
                        <img src="<?= get_the_post_thumbnail_url($article_3) ?>" alt="<?= the_post_thumbnail_caption($article_3) ?>">
                        <?php
                        $term = wp_get_post_terms( $article_3->ID, "category" )[0];
                        ?>
                        <div class="tag"><?= str_replace( ' ', '', $term->name ); ?></div>
                    </div>
                    <div class="content">
                        <h3 class="title"><?= get_the_title($article_3->ID) ?></h3>
                        <p class="author"><?= get_the_author_meta('display_name', $article_3->post_author) ?></p>
                        <p class="text"><?= get_the_excerpt($article_3->ID) ?></p>
                        <span class="date"><?= get_the_date( "d/m/Y", $article_3 ) ?></span>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>
<?php
get_footer();