<?php
$landing = get_field( 'landing' );
$expertise = get_field( 'expertise' );
$leader = get_field( 'leader' );
$equipe = get_field( 'equipe' );
?>
<div class="entreprise">
    <div class="landing">
        <img src="/wp-content/uploads/2023/04/filtre-blanc.png" alt="" class="filter">
        <div class="container">
            <h1 class="text-blanc"><?= $landing['title'] ?></h1>
            <p class="text-blanc"><?= $landing['text'] ?></p>
            <div class="btn">
                <a href="<?= $landing['button']['url'] ?>"><?= $landing['button']['title'] ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                    <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                        <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                    </g>
                    </svg>
                </a>
            </div>
        </div>
    </div><!-- landing -->
    <div class="expertise">
        <div class="container">
            <span class="mini_title">
                <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    Technical expertise in your parts
                <?php } else { ?>
                    L’expertise technique de vos pièces
                <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2><?= $expertise['title'] ?></h2>
            <div class="content">
                <div class="col">
						<img src="<?= $expertise['1']['image']['url'] ?>" alt="<?= $expertise['1']['image']['alt'] ?>">
                    <div class="textarea">
                        <div class="angle bottom left"></div>
                        <?= $expertise['1']['text'] ?>
                        <span><?= $expertise['1']['sub_text'] ?></span>
                    </div>
                </div>
                <div class="col">
                    <div class="angle top right"></div>
                    <p class="text"><?= $expertise['2']['text'] ?></p>
                    <div class="btn">
                        <a href="<?= $expertise['2']['button']['url'] ?>"><?= $expertise['2']['button']['title'] ?>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                            <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                                <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            </g>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- expertise -->
    <div class="leader">
        <img class="background" src="/wp-content/uploads/2023/05/Groupe-91-1.png" alt="Fond">
        <div class="container">
            <span class="mini_title">
            <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    Expertise of the leading metallurgical company
                <?php } else { ?>
                    L’expertise du leader de la métallurgie
                <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2 class="text-blanc"><?= $leader['title'] ?></h2>
            <div class="content">
                <div class="col">
                    <div class="angle white left top"></div>
                    <?= $leader['text'] ?>
                    <div class="btn">
                        <a href="<?= $leader['button']['url'] ?>"><?= $leader['button']['title'] ?>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                            <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                                <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                                <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            </g>
                            </svg>
                        </a>
                    </div>
                </div>
                <div class="col">
                    <img src="<?= $leader['image']['url'] ?>" alt="<?= $leader['image']['alt'] ?>">
                    <div class="angle white bottom right"></div>
                    <?= $leader['sub_text'] ?>
                </div>
            </div>
        </div>
    </div><!-- leader -->
    <div class="equipe">
        <div class="container">
            <span class="mini_title">
                <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    Our global teams
                <?php } else { ?>
                    Nos équipes mondiales
                <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2><?= $equipe['title'] ?></h2>
            <?= $equipe['text'] ?>
            <div class="map">
                <div class="card asie">
                    <span class="mini_title">
                        <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                            More than 25 partners
                        <?php } else { ?>
                            Plus de 25 partenaires
                        <?php } ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $equipe['asie']['title'] ?></h2>
                    <?= $equipe['asie']['text'] ?>
                </div>
                <img src="<?= $equipe['map']['url'] ?>" alt="<?= $equipe['map']['alt'] ?>">
                <div class="card europe">
                    <span class="mini_title">
                        <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                            Commercial presence
                        <?php } else { ?>
                            Présence commerciale
                        <?php } ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $equipe['europe']['title'] ?></h2>
                    <?= $equipe['europe']['text'] ?>
                </div>
                <div class="legend">
                    <div class="item">
                        <div class="point"></div>
                        <span>
                            <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                                Commercial presence
                            <?php } else { ?>
                                Présence commerciale
                            <?php } ?>
                        </span>
                    </div>
                    <div class="item">
                        <div class="point"></div>
                        <span>
                            <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                                +25 partners
                            <?php } else { ?>
                                +25 partenaires
                            <?php } ?>
                        </span>
                    </div>
                </div>
            </div>
            <div class="localisation">
                <div class="item">
                    <div class="title">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16.5" height="26.4" viewBox="0 0 16.5 26.4">
                            <g id="Groupe_132" data-name="Groupe 132" transform="translate(-578.36 -2938.705)">
                                <g id="Tracé_72" data-name="Tracé 72" transform="translate(579.899 2941.296)" fill="#fff">
                                    <path d="M 6.702600002288818 12.32236194610596 C 3.282469987869263 12.32236194610596 0.5 9.670622825622559 0.5 6.411182403564453 C 0.5 3.151742458343506 3.282469987869263 0.500002384185791 6.702600002288818 0.500002384185791 C 10.12273025512695 0.500002384185791 12.90520000457764 3.151742458343506 12.90520000457764 6.411182403564453 C 12.90520000457764 9.670622825622559 10.12273025512695 12.32236194610596 6.702600002288818 12.32236194610596 Z" stroke="none"/>
                                    <path d="M 6.702600002288818 1.000002861022949 C 3.55817985534668 1.000002861022949 1 3.427452087402344 1 6.411182403564453 C 1 9.394912719726562 3.55817985534668 11.82236289978027 6.702600002288818 11.82236289978027 C 9.847020149230957 11.82236289978027 12.40520000457764 9.394912719726562 12.40520000457764 6.411182403564453 C 12.40520000457764 3.427452087402344 9.847020149230957 1.000002861022949 6.702600002288818 1.000002861022949 M 6.702600002288818 2.86102294921875e-06 C 10.40433979034424 2.86102294921875e-06 13.40520000457764 2.870382308959961 13.40520000457764 6.411182403564453 C 13.40520000457764 9.951982498168945 10.40433979034424 12.82236194610596 6.702600002288818 12.82236194610596 C 3.000860214233398 12.82236194610596 0 9.951982498168945 0 6.411182403564453 C 0 2.870382308959961 3.000860214233398 2.86102294921875e-06 6.702600002288818 2.86102294921875e-06 Z" stroke="none" fill="#707070"/>
                                </g>
                                <path id="Icon_metro-location" data-name="Icon metro-location" d="M16.6,1.928a8.25,8.25,0,0,0-8.25,8.25c0,8.25,8.25,18.15,8.25,18.15s8.25-9.9,8.25-18.15a8.25,8.25,0,0,0-8.25-8.25Zm0,13.3a5.053,5.053,0,1,1,5.053-5.053A5.053,5.053,0,0,1,16.6,15.231Zm-3.2-5.053a3.2,3.2,0,1,1,3.2,3.2A3.2,3.2,0,0,1,13.408,10.178Z" transform="translate(570.005 2936.777)" fill="#bc965c"/>
                            </g>
                        </svg>
                        <h3><?= $equipe['points']['1']['title'] ?></h3>
                    </div>
                    <div class="text"><?= $equipe['points']['1']['text'] ?></div>
                    <div class="address"><?= $equipe['points']['1']['address'] ?></div>
                </div>
                <div class="item">
                    <div class="title">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16.5" height="26.4" viewBox="0 0 16.5 26.4">
                            <g id="Groupe_132" data-name="Groupe 132" transform="translate(-578.36 -2938.705)">
                                <g id="Tracé_72" data-name="Tracé 72" transform="translate(579.899 2941.296)" fill="#fff">
                                    <path d="M 6.702600002288818 12.32236194610596 C 3.282469987869263 12.32236194610596 0.5 9.670622825622559 0.5 6.411182403564453 C 0.5 3.151742458343506 3.282469987869263 0.500002384185791 6.702600002288818 0.500002384185791 C 10.12273025512695 0.500002384185791 12.90520000457764 3.151742458343506 12.90520000457764 6.411182403564453 C 12.90520000457764 9.670622825622559 10.12273025512695 12.32236194610596 6.702600002288818 12.32236194610596 Z" stroke="none"/>
                                    <path d="M 6.702600002288818 1.000002861022949 C 3.55817985534668 1.000002861022949 1 3.427452087402344 1 6.411182403564453 C 1 9.394912719726562 3.55817985534668 11.82236289978027 6.702600002288818 11.82236289978027 C 9.847020149230957 11.82236289978027 12.40520000457764 9.394912719726562 12.40520000457764 6.411182403564453 C 12.40520000457764 3.427452087402344 9.847020149230957 1.000002861022949 6.702600002288818 1.000002861022949 M 6.702600002288818 2.86102294921875e-06 C 10.40433979034424 2.86102294921875e-06 13.40520000457764 2.870382308959961 13.40520000457764 6.411182403564453 C 13.40520000457764 9.951982498168945 10.40433979034424 12.82236194610596 6.702600002288818 12.82236194610596 C 3.000860214233398 12.82236194610596 0 9.951982498168945 0 6.411182403564453 C 0 2.870382308959961 3.000860214233398 2.86102294921875e-06 6.702600002288818 2.86102294921875e-06 Z" stroke="none" fill="#707070"/>
                                </g>
                                <path id="Icon_metro-location" data-name="Icon metro-location" d="M16.6,1.928a8.25,8.25,0,0,0-8.25,8.25c0,8.25,8.25,18.15,8.25,18.15s8.25-9.9,8.25-18.15a8.25,8.25,0,0,0-8.25-8.25Zm0,13.3a5.053,5.053,0,1,1,5.053-5.053A5.053,5.053,0,0,1,16.6,15.231Zm-3.2-5.053a3.2,3.2,0,1,1,3.2,3.2A3.2,3.2,0,0,1,13.408,10.178Z" transform="translate(570.005 2936.777)" fill="#bc965c"/>
                            </g>
                        </svg>
                        <h3><?= $equipe['points']['2']['title'] ?></h3>
                    </div>
                    <div class="text"><?= $equipe['points']['2']['text'] ?></div>
                    <div class="address"><?= $equipe['points']['2']['address'] ?></div>
                </div>
                <div class="item">
                    <div class="title">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16.5" height="26.4" viewBox="0 0 16.5 26.4">
                            <g id="Groupe_131" data-name="Groupe 131" transform="translate(-559.346 -2954.151)">
                                <g id="Ellipse_18" data-name="Ellipse 18" transform="translate(560.867 2956.699)" fill="#fff" stroke="#707070" stroke-width="1">
                                    <ellipse cx="6.729" cy="6.303" rx="6.729" ry="6.303" stroke="none"/>
                                    <ellipse cx="6.729" cy="6.303" rx="6.229" ry="5.803" fill="none"/>
                                </g>
                                <path id="Icon_metro-location" data-name="Icon metro-location" d="M16.6,1.928a8.25,8.25,0,0,0-8.25,8.25c0,8.25,8.25,18.15,8.25,18.15s8.25-9.9,8.25-18.15a8.25,8.25,0,0,0-8.25-8.25Zm0,13.3a5.053,5.053,0,1,1,5.053-5.053A5.053,5.053,0,0,1,16.6,15.231Zm-3.2-5.053a3.2,3.2,0,1,1,3.2,3.2A3.2,3.2,0,0,1,13.408,10.178Z" transform="translate(550.991 2952.223)" fill="#0c1f40"/>
                            </g>
                        </svg>
                        <h3><?= $equipe['points']['3']['title'] ?></h3>
                    </div>
                    <div class="text"><?= $equipe['points']['3']['text'] ?></div>
                    <div class="address"><?= $equipe['points']['3']['address'] ?></div>
                </div>
            </div>
        </div>
    </div><!-- equipe -->
</div>