<?php
$landing = get_field( 'landing' );
$conception = get_field( 'conception' );
$livraison = get_field( 'livraison' );
$contact_us = get_field( 'contact' );
?>
<div class="solutions">
<div class="landing">
        <img src="/wp-content/uploads/2023/04/filtre-blanc.png" alt="" class="filter">
        <div class="container">
            <h1 class="text-blanc"><?= $landing['title'] ?></h1>
            <p class="text-blanc"><?= $landing['text'] ?></p>
            <div class="btn">
                <a href="<?= $landing['button']['url'] ?>"><?= $landing['button']['title'] ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                    <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                        <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                    </g>
                    </svg>
                </a>
            </div>
        </div>
    </div><!-- landing -->
    <div class="conception">
        <div class="container">
            <span class="mini_title">
                <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    From design to delivery
                <?php } else { ?>
                    De la conception à la livraison
                <?php } ?>
            </span>
            <h2><?= $conception['title'] ?></h2>
            <div class="btn">
                <a href="<?= $conception['button']['url'] ?>"><?= $conception['button']['title'] ?></a>
            </div>
            <div class="arrow">
                <svg xmlns="http://www.w3.org/2000/svg" width="13.992" height="8" viewBox="0 0 13.992 8">
                    <path id="Icon_ionic-ios-arrow-down" data-name="Icon ionic-ios-arrow-down" d="M13.186,16.835l5.291-5.295a1,1,0,0,1,1.412,0,1.008,1.008,0,0,1,0,1.416l-5.995,6a1,1,0,0,1-1.379.029L6.479,12.961a1,1,0,1,1,1.412-1.416Z" transform="translate(20.179 19.246) rotate(180)" fill="#bc965c"/>
                </svg>
            </div>
        </div>
    </div><!-- conception -->
    <div id="livraison" class="livraison"> 
         
        <div class="container">
            <div class="col follow-step desktop" >
                <div class="content" id="colSticky">
                    <a href="#engineeringancre">
                    <div class="part" id="engineering">
                        <div class="text"><?= $livraison['scroll']['1']['title'] ?></div>
                        <div class="bullet">
                            <img src="<?= $livraison['scroll']['1']['image']['url'] ?>" alt="<?= $livraison['scroll']['1']['image']['alt'] ?>">
                        </div>
                    </div>
                    </a>
                    <a href="#sourcingancre">
                    <div class="part" id="sourcing">
                        <div class="text"><?= $livraison['scroll']['2']['title'] ?></div>
                        <div class="bullet">
                            <img src="<?= $livraison['scroll']['2']['image']['url'] ?>" alt="<?= $livraison['scroll']['2']['image']['alt'] ?>">
                        </div>
                    </div>
                    </a>
                    <a href="#productionancre">
                    <div class="part" id="production">
                        <div class="text"><?= $livraison['scroll']['3']['title'] ?></div>
                        <div class="bullet">
                            <img src="<?= $livraison['scroll']['3']['image']['url'] ?>" alt="<?= $livraison['scroll']['3']['image']['alt'] ?>">
                        </div>
                    </div>
                    </a>
                    <a href="#inspectionancre">
                    <div class="part" id="inspection">
                        <div class="text"><?= $livraison['scroll']['4']['title'] ?></div>
                        <div class="bullet">
                            <img src="<?= $livraison['scroll']['4']['image']['url'] ?>" alt="<?= $livraison['scroll']['4']['image']['alt'] ?>">
                        </div>
                    </div>
                    </a>
                    <a href="#stockageancre">
                    <div class="part" id="stockage">
                        <div class="text"><?= $livraison['scroll']['5']['title'] ?></div>
                        <div class="bullet">
                            <img src="<?= $livraison['scroll']['5']['image']['url'] ?>" alt="<?= $livraison['scroll']['5']['image']['alt'] ?>">
                        </div>
                    </div>
                    </a>
                    <a href="#satisfactionancre">
                    <div class="part" id="satisfaction">
                        <div class="text"><?= $livraison['scroll']['6']['title'] ?></div>
                        <div class="bullet">
                            <img src="<?= $livraison['scroll']['6']['image']['url'] ?>" alt="<?= $livraison['scroll']['6']['image']['alt'] ?>">
                        </div>
                    </div>
                    </a>
                </div>
            </div>
            <div class="col steps" >
                <span id="engineeringancre" class=""></span>
                <div class="step" id="engineering">
                    <span class="mini_title" id="">
                        01
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $livraison['step']['1']['title'] ?></h2>
                    <?= $livraison['step']['1']['text_1'] ?>
                    <div class="image">
                        <div class="card">
                            <?= $livraison['step']['1']['card_1'] ?>
                        </div>
                        <img src="<?= $livraison['step']['1']['image']['url'] ?>" alt="<?= $livraison['step']['1']['image']['alt'] ?>">
                        <div class="card">
                            <?= $livraison['step']['1']['card_2'] ?>
                        </div>
                    </div>
                    <?= $livraison['step']['1']['text_2'] ?>
                </div>
                <span id="sourcingancre" class=""></span>
                <div class="step" id="sourcing">
                    <span class="mini_title" id="">
                        02
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $livraison['step']['2']['title'] ?></h2>
                    <?= $livraison['step']['2']['text_1'] ?>
                    <img src="<?= $livraison['step']['2']['image']['url'] ?>" alt="<?= $livraison['step']['2']['image']['alt'] ?>">
                    <?= $livraison['step']['2']['text_2'] ?>
                </div>
                <span id="productionancre" class=""></span>
                <div class="step" id="production">
                    <span class="mini_title" id="">
                        03
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $livraison['step']['3']['title'] ?></h2>
                    <div class="grid">
                        <div><?= $livraison['step']['3']['text_1'] ?></div>
                        <div><?= $livraison['step']['3']['text_2'] ?></div>
                    </div>
                    <img src="<?= $livraison['step']['3']['image']['url'] ?>" alt="<?= $livraison['step']['3']['image']['alt'] ?>">
                    <?= $livraison['step']['3']['text_3'] ?>
                </div>
                <span id="inspectionancre" class=""></span>
                <div class="step" id="inspection">
                    <span class="mini_title" id="">
                        04
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $livraison['step']['4']['title'] ?></h2>
                    <?= $livraison['step']['4']['text_1'] ?>
                    <div class="grid">
                        <img src="<?= $livraison['step']['4']['image']['url'] ?>" alt="<?= $livraison['step']['4']['image']['alt'] ?>">
                        <?= $livraison['step']['4']['text_2'] ?>
                    </div>
                    <div class="card">
                        <?= $livraison['step']['4']['card'] ?>
                    </div>
                </div>
                <span id="stockageancre" class=""></span>
                <div class="step" id="stockage">
                    <span class="mini_title" id="">
                        05
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $livraison['step']['5']['title'] ?></h2>
                    <?= $livraison['step']['5']['text_1'] ?>
                    <div class="grid">
                        <img src="<?= $livraison['step']['5']['image']['url'] ?>" alt="<?= $livraison['step']['5']['image']['alt'] ?>">
                        <div class="legende">
                            <?= $livraison['step']['5']['text_2'] ?>
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="15.201" height="13.199" viewBox="0 0 15.201 13.199">
                                    <path id="_80d47b39b37fc861efef8ec517b0f5ac" data-name="80d47b39b37fc861efef8ec517b0f5ac" d="M14.684,16.6a3,3,0,0,0,0-6c-2.915,0-.972-5.8,2.916-5.8V3.4C10.661,3.4,7.942,16.6,14.684,16.6Zm-8.4,0a3,3,0,0,0,0-6c-2.916,0-.973-5.8,2.915-5.8V3.4C2.261,3.4-.458,16.6,6.284,16.6Z" transform="translate(-2.399 -3.401)" fill="#bc965c"/>
                                </svg>
                                <?= $livraison['step']['5']['legende'] ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="15.201" height="13.199" viewBox="0 0 15.201 13.199">
                                    <path id="_80d47b39b37fc861efef8ec517b0f5ac" data-name="80d47b39b37fc861efef8ec517b0f5ac" d="M5.315,3.4A2.959,2.959,0,0,0,2.4,6.4a2.96,2.96,0,0,0,2.916,3c2.915,0,.972,5.8-2.916,5.8v1.4C9.338,16.6,12.057,3.4,5.315,3.4Zm8.4,0a2.959,2.959,0,0,0-2.915,3,2.96,2.96,0,0,0,2.915,3c2.916,0,.973,5.8-2.915,5.8v1.4C17.738,16.6,20.457,3.4,13.715,3.4Z" transform="translate(-2.399 -3.401)" fill="#bc965c"/>
                                </svg>
                            </span>
                        </div>
                    </div>
                    <?= $livraison['step']['5']['text_3'] ?>
                    <div class="icon">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="47" height="47" viewBox="0 0 47 47">
                                <image id="clock" width="47" height="47" xlink:href="data:image/png;base64,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"/>
                            </svg>
                            <?= $livraison['step']['5']['text_4'] ?>
                        </div>
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="51" height="51" viewBox="0 0 51 51">
                                <image id="camion-conteneur" width="51" height="51" xlink:href="data:image/png;base64,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"/>
                            </svg>
                            <?= $livraison['step']['5']['text_5'] ?>
                        </div>
                    </div>
                </div>
                <span id="satisfactionancre" class=""></span>
                <div class="step" id="satisfaction">
                    <span class="mini_title" id="">
                        06
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $livraison['step']['6']['title'] ?></h2>
                    <div class="text">
                        <?= $livraison['step']['6']['text'] ?>
                    </div>
                    <div class="image">
                        <img src="<?= $livraison['step']['6']['image']['url'] ?>" alt="<?= $livraison['step']['6']['image']['alt'] ?>">
                        <div class="card">
                            <img src="<?= $livraison['step']['6']['card']['image']['url'] ?>" alt="<?= $livraison['step']['6']['card']['image']['alt'] ?>">
                            <div class="text">
                                <p class="title"><?= $livraison['step']['6']['card']['chiffres'] ?></p>
                                <p><?= $livraison['step']['6']['card']['text'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- livraison -->
    <div class="contact-us">
        <div class="container">
            <div class="col">
                <span class="mini_title">
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                        Contact us
                    <?php } else { ?>
                        Contactez-nous
                    <?php } ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                        <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                    </svg>
                </span>
                <h2><?= $contact_us['title'] ?></h2>
                <?= $contact_us['text'] ?>
            </div>
            <div class="col">
                <div class="btn">
                    <a href="<?= $contact_us['button']['url'] ?>"><?= $contact_us['button']['title'] ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                        <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                            <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        </g>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div><!-- contact-us -->
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js"></script>
<script>

// animation solution



function applyScrollTrigger() {
  gsap.registerPlugin(ScrollTrigger);

  if (window.innerWidth > 1024) {
    gsap.to("#colSticky", {
      y: 0,
      scrollTrigger: {
        trigger: ".col.steps",
        start: "top top",
        end: "bottom bottom",
        pin: "#colSticky",
        scrub: 0,
      }
    });
  }
}

applyScrollTrigger();

window.addEventListener('resize', function() {
  ScrollTrigger.getAll().forEach(function(trigger) {
    trigger.kill();
  });

  applyScrollTrigger();
});



// animation solution active pour desktop

// Récupérer tous les éléments avec la classe "step"
const steps = document.querySelectorAll('.step');

// Ajouter un événement scroll à la fenêtre
window.addEventListener('scroll', function() {
  // Récupérer la position verticale du milieu de l'écran
  const middleScreen = window.innerHeight / 2;

  // Parcourir tous les éléments avec la classe "step"
  steps.forEach(function(step) {
    // Récupérer la position verticale de l'élément
    const rect = step.getBoundingClientRect();
    const elementTop = rect.top;
    const elementBottom = rect.bottom;

    // Activer l'élément correspondant si son haut touche le milieu de l'écran
    if (elementTop <= middleScreen && elementBottom >= middleScreen) {
      // Désactiver tous les éléments de classe "part"
      document.querySelectorAll('.part').forEach(function(part) {
        part.classList.remove('active');
      });

      // Activer l'élément correspondant
      const stepId = step.getAttribute('id');
      document.getElementById(stepId).classList.add('active');
    }
  });
});




    // ============ SCROLL SECTION - SOLUTIONS ============
    function setActivePart() {
  var parts = document.getElementsByClassName('part');
  var steps = document.getElementsByClassName('step');
  var activeStepIndex = -1;

  for (var i = 0; i < steps.length; i++) {
    var step = steps[i];
    var stepRect = step.getBoundingClientRect();
    if (stepRect.top >= 0 && stepRect.top <= window.innerHeight) {
      activeStepIndex = i;
      break;
    }
  }

  for (var j = 0; j < parts.length; j++) {
    var part = parts[j];
    if (j === activeStepIndex) {
      part.classList.add('active');
    } else {
      part.classList.remove('active');
    }
  }
}

document.getElementsByClassName('col steps')[0].addEventListener('scroll', setActivePart);

</script>