<?php

if ( ! defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly.

}


// Ajout de Gsap
// function add_gsap() {
//   wp_enqueue_script('jquery', 'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js');
//   wp_enqueue_script('gsap', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js', array('jquery'));
//   wp_enqueue_script('gsap-scrolltrigger', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js', array('jquery'));
//   wp_enqueue_script('smooth-scrollbar', 'https://cdnjs.cloudflare.com/ajax/libs/smooth-scrollbar/8.8.3/smooth-scrollbar.min.js');
// }
// add_action('wp_enqueue_scripts', 'add_gsap');


/*
* Enable support for Post Thumbnails on posts and pages.
*
* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
*/
add_theme_support( 'post-thumbnails' );


//add scripts and styles

add_action( 'wp_enqueue_scripts', 'wpm_enqueue_styles' );

function wpm_enqueue_styles(){

    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

    wp_enqueue_script( 'mainjs',get_template_directory_uri().'/src/js/script.js', array() );

}



function lbt_theme_custom_logo_setup() {

    $defaults = array(

        'flex-height'          => true,

        'flex-width'           => true,

    );

    add_theme_support( 'custom-logo', $defaults );

}

add_action( 'after_setup_theme', 'lbt_theme_custom_logo_setup' );



function register_my_menus() {

  register_nav_menus(

    array(

      'header-menu' => __( 'Header Menu' )

    )

  );

}

add_action( 'init', 'register_my_menus' );



function cc_mime_types($mimes) {

  $mimes['svg'] = 'image/svg+xml';

  return $mimes;

}

add_filter('upload_mimes', 'cc_mime_types');



// Activation de jQuery

function activate_jquery() {

  wp_enqueue_script('jquery');

}
add_action('wp_enqueue_scripts', 'activate_jquery');

// Ajout de splidejs
function add_splidejs() {
  wp_enqueue_script('splidejs', get_template_directory_uri() . '/inc/splide-4.1.3/dist/js/splide.min.js', array('jquery'));
  wp_enqueue_style( 'splidejs-style', get_template_directory_uri() . '/inc/splide-4.1.3/dist/css/splide.min.css' );
}
add_action('wp_enqueue_scripts', 'add_splidejs');


// Ajout de slickjs
function css_slickjs() {
  ?>
  <!-- Add the slick-theme.css if you want default styling -->
  <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
  <!-- Add the slick-theme.css if you want default styling -->
  <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
  <?php
}
add_action('wp_head', 'css_slickjs');

function js_slickjs() {
  ?>
  <script type="text/javascript" src="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
  <?php
}
add_action('wp_head', 'js_slickjs');


function google_analytics() { ?>
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-33C56DRH95"></script>
  <script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date()); 
  gtag('config', 'G-33C56DRH95');
  </script>
<?php }
add_action( 'wp_head', 'google_analytics');
