<?php
    $landing = get_field( 'landing' );
    $entreprise = get_field( 'entreprise' );
    $chiffres_cles = get_field( 'chiffres-cles' );
        $keys = $chiffres_cles['keys'];
    $notre_process = get_field( 'notre-process' );
        $etapes = $notre_process['etapes'];
    $temoignages = get_field( 'temoignages' );
        $temoins = $temoignages['temoins'];
    $nos_actualites = get_field( 'nos-actualites' );
        $actu_slider = $nos_actualites['carrousel'];
    $nos_clients = get_field( 'nos-clients' );
        $client_slider = $nos_clients['carrousel'];
?>
<div class="home">
    <div class="landing">
        <img src="/wp-content/uploads/2023/04/filtre-blanc.png" alt="" class="filter">
        <video autoplay muted loop playsinline id="background-video">
            <source src="<?= $landing['background']['url'] ?>" type="video/mp4">
        </video>
        <div class="container">
            <h1 class=""><?= $landing['title'] ?></h1>
            <p class=""><?= $landing['text'] ?></p>
            <div class="btn">
                <a href="<?= $landing['button']['url'] ?>"><?= $landing['button']['title'] ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                    <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                        <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                    </g>
                    </svg>
                </a>
            </div>
        </div>
        <div class="just-scroll desktop">
            <div class="container">
                <svg xmlns="http://www.w3.org/2000/svg" width="8.842" height="19.704" viewBox="0 0 8.842 19.704">
                    <g id="Groupe_2" data-name="Groupe 2" transform="translate(7.428 1) rotate(90)">
                        <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                        <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                        <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                    </g>
                </svg>
            </div>
        </div>
    </div><!-- #landing -->
    <div class="entreprise">
        <div class="container row">
            <div class="col">
                <img src="<?= $entreprise['image']['url'] ?>" alt="<?= $entreprise['image']['alt'] ?>">
                <div class="card">
                    <img src="<?= $entreprise['card']['image']['url'] ?>" alt alt="<?= $entreprise['card']['image']['url'] ?>">
                    <div class="">
                        <p class="text-blanc"><?= $entreprise['card']['text'] ?></p>
                        <p class="age font-rubik font-medium text-maron"><?= $entreprise['card']['age'] ?></p>
                    </div>
                </div>
            </div>
            <div class="col">
                <span class="mini_title">
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                        The Company
                    <?php } else { ?>
                        L'entreprise
                    <?php } ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                        <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                    </svg>
                </span>
                <h2 class=""><?= $entreprise['title'] ?></h2>
                <div class=""><?= $entreprise['text_1'] ?></div>
                <div class="ml"><?= $entreprise['text_2'] ?></div>
                <div class="btn ml">
                    <a href="<?= $entreprise['button']['url'] ?>"><?= $entreprise['button']['title'] ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                        <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                            <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        </g>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div><!-- #entreprise -->
    <div class="chiffres_cles">
        <div class="container">
            <span class="mini_title">
            <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                Key figures
            <?php } else { ?>
                Chiffres clés
            <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2 class=""><?= $chiffres_cles['title'] ?></h2>
            <div class="keys-container">
                <div class="keys">
                    <span class=""><?= $keys['1']['chiffre'] ?></span>
                    <p class=""><?= $keys['1']['text'] ?></p>
                </div>
                <div class="keys">
                    <span class=""><?= $keys['2']['chiffre'] ?></span>
                    <p class=""><?= $keys['2']['text'] ?></p>
                </div>
                <div class="keys">
                    <span class=""><?= $keys['3']['chiffre'] ?></span>
                    <p class=""><?= $keys['3']['text'] ?></p>
                </div>
                <div class="keys">
                    <span class=""><?= $keys['4']['chiffre'] ?></span>
                    <p class=""><?= $keys['4']['text'] ?></p>
                </div>
            </div>
        </div>
    </div><!-- #chiffres_cles -->
    <div id="process" class="notre_process">
    <h2 class="titleNotreProcessMobile"><?= $notre_process['title'] ?></h2>
        <div class="container">
            <div class="col">
                <div class="processus desktop">
                    <h2 class=""><?= $notre_process['title'] ?></h2>
                    <div id="etape_1" class="etape">
                        <span class="part">
                            <p><span>01</span><?= $etapes['1']['title'] ?></p>
                            <svg class="" xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                                <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#ffffff" stroke-width="1"/>
                            </svg>
                        </span>
                    </div>
                    <div id="etape_2" class="etape">
                        <span class="part">
                            <p><span>02</span><?= $etapes['2']['title'] ?></p>
                            <svg class="" xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                                <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#ffffff" stroke-width="1"/>
                            </svg>
                        </span>
                    </div>
                    <div id="etape_3" class="etape">
                        <span class="part">
                            <p><span>03</span><?= $etapes['3']['title'] ?></p>
                            <svg class="" xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                                <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#ffffff" stroke-width="1"/>
                            </svg>
                        </span>
                    </div>
                    <div id="etape_4" class="etape">
                        <span class="part">
                            <p><span>04</span><?= $etapes['4']['title'] ?></p>
                            <svg class="" xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                                <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#ffffff" stroke-width="1"/>
                            </svg>
                        </span>
                    </div>
                    <div id="etape_5" class="etape">
                        <span class="part">
                            <p><span>05</span><?= $etapes['5']['title'] ?></p>
                            <svg class="" xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                                <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#ffffff" stroke-width="1"/>
                            </svg>
                        </span>
                    </div>
                    <div id="etape_6" class="etape">
                        <span class="part">
                            <p><span>06</span><?= $etapes['6']['title'] ?></p>
                            <svg class="" xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                                <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#ffffff" stroke-width="1"/>
                            </svg>
                        </span>
                    </div>
                </div>
            </div>
          
            <div id="explain-scrolling" class="col">
                <div class="explain-scrolling-step explain1">
                    <span class="mini_title">
                        01
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $etapes['1']['title'] ?></h2>
                    <?= $etapes['1']['text'] ?>
                    <img src="<?= $etapes['1']['image']['url'] ?>" alt="<?= $etapes['1']['image']['alt'] ?>">
                </div>
                <div class="explain-scrolling-step explain2">
                    <span class="mini_title">
                        02
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $etapes['2']['title'] ?></h2>
                    <?= $etapes['2']['text'] ?>
                    <img src="<?= $etapes['2']['image']['url'] ?>" alt="<?= $etapes['2']['image']['alt'] ?>">
                </div>
                <div class="explain-scrolling-step explain3">
                    <span class="mini_title">
                        03
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $etapes['3']['title'] ?></h2>
                    <?= $etapes['3']['text'] ?>
                    <img src="<?= $etapes['3']['image']['url'] ?>" alt="<?= $etapes['3']['image']['alt'] ?>">
                </div>
                <div class="explain-scrolling-step explain4">
                    <span class="mini_title">
                        04
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $etapes['4']['title'] ?></h2>
                    <?= $etapes['4']['text'] ?>
                    <img src="<?= $etapes['4']['image']['url'] ?>" alt="<?= $etapes['4']['image']['alt'] ?>">
                </div>
                <div class="explain-scrolling-step explain5">
                    <span class="mini_title">
                        05
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $etapes['5']['title'] ?></h2>
                    <?= $etapes['5']['text'] ?>
                    <img src="<?= $etapes['5']['image']['url'] ?>" alt="<?= $etapes['5']['image']['alt'] ?>">
                </div>
                <div class="explain-scrolling-step explain6">
                    <span class="mini_title">
                        06
                        <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                            <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                        </svg>
                    </span>
                    <h2><?= $etapes['6']['title'] ?></h2>
                    <?= $etapes['6']['text'] ?>
                    <img src="<?= $etapes['6']['image']['url'] ?>" alt="<?= $etapes['6']['image']['alt'] ?>">
                </div>
            </div>
        </div>
    </div><!-- #notre_process -->
    <div class="temoignages">
        <img class="background" src="/wp-content/uploads/2023/04/Groupe-91.png" alt="Fond">
        <div class="container">
            <span class="mini_title">
                <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    Testimonials
                <?php } else { ?>
                    Témoignages
                <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2 class="text-blanc"><?= $temoignages['title'] ?></h2>
            <?= $temoignages['text'] ?>
            <div class="temoins">
                <div class="col">
                    <div class="textarea"><?= $temoins['1']['text'] ?></div>
                    <div class="info">
                        <img src="<?= $temoins['1']['image']['url'] ?>" alt="<?= $temoins['1']['image']['alt'] ?>">
                        <div class="textarea">
                            <p><?= $temoins['1']['name'] ?></p>
                            <p><?= $temoins['1']['fonction'] ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="textarea"><?= $temoins['2']['text'] ?></div>
                    <div class="info">
                        <img src="<?= $temoins['2']['image']['url'] ?>" alt="<?= $temoins['2']['image']['alt'] ?>">
                        <div class="textarea">
                            <p><?= $temoins['2']['name'] ?></p>
                            <p><?= $temoins['2']['fonction'] ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- #temoignages -->
    <div class="nos_actualites">
        <div class="container">
            <div class="col">
                <span class="mini_title">
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                        Our news
                    <?php } else { ?>
                        Nos actualités
                    <?php } ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                        <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                    </svg>
                </span>
                <h2><?= $nos_actualites['title'] ?></h2>
                <p><?= $nos_actualites['text'] ?></p>
                <div class="btn desktop">
                    <a href="<?= $nos_actualites['button']['url'] ?>"><?= $nos_actualites['button']['title'] ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                        <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                            <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        </g>
                        </svg>
                    </a>
                </div>
            </div>
            <div class="col">
                <div class="actu-slider">
                    <div id="actu" class="splide" aria-label="Basic Structure Example">
                        <div class="splide__track">
                            <ul class="splide__list">
                                <?php
                                $args = array(
                                    'post_type'      => 'post',
                                    'posts_per_page' => 5,
                                );

                                $query = new WP_Query( $args );

                                if ( $query->have_posts() ) {
                                    while ( $query->have_posts() ) {
                                        $query->the_post();
                                        $post_id       = get_the_ID();
                                        $post_link     = get_permalink();
                                        $post_title    = get_the_title();
                                        $post_image    = get_the_post_thumbnail_url();
                                        $term          = wp_get_post_terms( $post_id, "category" )[0];
                                        $post_date     = get_the_date("d/m/Y");
                                        $post_author   = get_the_author();
                                        $post_excerpt  = get_the_excerpt();
                                        $first_tag     = '';
                                        
                                        if ( $post_tags ) {
                                            $first_tag = $post_tags[0]->name;
                                        }
                                        ?>
                                        
                                        <!-- Insérer ici votre code HTML pour afficher les informations de l'article -->
                                        <li class="splide__slide card">
                                            <a href="<?= $post_link ?>">
                                                <div class="image">
                                                    <img src="<?= $post_image ?>" alt="img">
                                                    <div class="tag"><?= str_replace( ' ', '', $term->name ); ?></div>
                                                </div>
                                                <div class="content">
                                                    <h3 class="title"><?= $post_title ?></h3>
                                                    <p class="author"><?= $post_author ?></p>
                                                    <p class="text"><?= $post_excerpt ?></p>
                                                    <span class="date"><?= $post_date ?></span>
                                                </div>
                                            </a>
                                        </li>
                                        
                                        <?php
                                    }
                                }

                                wp_reset_postdata();
                                ?>
                            </ul>
                        </div>
                        <div class="splide__arrows">
                            <button class="splide__arrow splide__arrow--prev">
                                <svg xmlns="http://www.w3.org/2000/svg" width="9.828" height="16.828" viewBox="0 0 9.828 16.828">
                                    <g id="Groupe_95" data-name="Groupe 95" transform="translate(1.414 1.414)">
                                        <line id="Ligne_20" data-name="Ligne 20" x2="7" y2="7" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                        <line id="Ligne_21" data-name="Ligne 21" y1="7" x2="7" transform="translate(0 7)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                    </g>
                                </svg>
                            </button>
                            <button class="splide__arrow splide__arrow--next">
                                <svg xmlns="http://www.w3.org/2000/svg" width="9.828" height="16.828" viewBox="0 0 9.828 16.828">
                                    <g id="Groupe_95" data-name="Groupe 95" transform="translate(1.414 1.414)">
                                        <line id="Ligne_20" data-name="Ligne 20" x2="7" y2="7" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                        <line id="Ligne_21" data-name="Ligne 21" y1="7" x2="7" transform="translate(0 7)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                    </g>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="btn mobile">
                    <a href="<?= $nos_actualites['button']['url'] ?>"><?= $nos_actualites['button']['title'] ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                        <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                            <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                            <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        </g>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div><!-- #nos_actualites -->
    <div class="nos_clients">
        <div class="container">
            <span class="mini_title">
                <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    Our customers
                <?php } else { ?>
                    Nos clients
                <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2><?= $nos_clients['title'] ?></h2>
            <div class="carrousel">
                <div id="client" class="splide" aria-label="Basic Structure Example">
                    <div class="splide__track">
                        <ul class="splide__list">
                            <?php
                            // Récupérer les données du champ répéteur "slide"
                            $slides = $nos_clients['carrousel'];

                            // Vérifier si des slides sont disponibles
                            if ($slides) {
                                foreach ($slides as $slide) {
                                    // Récupérer les valeurs des sous-champs du slide
                                    $image = $slide['image']['url'];
                                    $alt = $slide['image']['alt'];
                                    ?>
                                    <li class="splide__slide">
                                        <img src="<?= $slide['image']['url']; ?>" alt="<?= $slide['image']['alt']; ?>">
                                    </li>
                                    <?php
                                }
                            }
                            ?>
                        </ul>
                    </div>
                    <div class="splide__arrows">
                        <button class="splide__arrow splide__arrow--prev">
                            <svg xmlns="http://www.w3.org/2000/svg" width="9.828" height="16.828" viewBox="0 0 9.828 16.828">
                                <g id="Groupe_95" data-name="Groupe 95" transform="translate(1.414 1.414)">
                                    <line id="Ligne_20" data-name="Ligne 20" x2="7" y2="7" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                    <line id="Ligne_21" data-name="Ligne 21" y1="7" x2="7" transform="translate(0 7)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                </g>
                            </svg>
                        </button>
                        <button class="splide__arrow splide__arrow--next">
                            <svg xmlns="http://www.w3.org/2000/svg" width="9.828" height="16.828" viewBox="0 0 9.828 16.828">
                                <g id="Groupe_95" data-name="Groupe 95" transform="translate(1.414 1.414)">
                                    <line id="Ligne_20" data-name="Ligne 20" x2="7" y2="7" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                    <line id="Ligne_21" data-name="Ligne 21" y1="7" x2="7" transform="translate(0 7)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="2"/>
                                </g>
                            </svg>
                        </button>
                    </div>
                </div>
            </div><!-- carrousel -->
        </div>
    </div><!-- #nos_clients -->
</div><!-- #home -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js"></script>
<script>





// rendre les titres actifs
document.addEventListener('DOMContentLoaded', function() {
    var steps = document.querySelectorAll('.explain-scrolling-step');
    var parts = document.querySelectorAll('.part');

    function activateStep() {
        var middleOfScreen = window.innerHeight / 2;

        steps.forEach(function(step, index) {
            var rect = step.getBoundingClientRect();
            var topPosition = rect.top;

            if (topPosition <= middleOfScreen) {
                parts.forEach(function(part) {
                    part.classList.remove('active');
                });

                var correspondingPart = document.querySelector('#etape_' + (index + 1));
                correspondingPart.querySelector('.part').classList.add('active');
            }
        });
    }

    document.addEventListener('scroll', activateStep);
});




// animation solution

gsap.registerPlugin(ScrollTrigger)

gsap.to(".processus", {

    y: 0,

    scrollTrigger: {
        trigger:"#explain-scrolling",
        start: "top top",
        end: "bottom bottom",
        pin: ".processus", 
        scrub: 0,
    }
})


// Nos actualités carrousel
new Splide( '#actu', {
    type   : 'loop',
    perPage: 2,
    perMove: 1,
    pagination: false,
    gap: '30px',
}).mount();

// Nos clients carrousel
new Splide( '#client', {
    type   : 'loop',
    perPage: 5,
    perMove: 1,
    pagination: false,
    gap: '35px',
}).mount();

// ============ SCROLL SECTION - HOME ============
// function setActivePart() {
//   var etapes = document.getElementsByClassName('etape');
//   var steps = document.getElementsByClassName('explain-scrolling-step');
//   var activeStepIndex = -1;

//   for (var i = 0; i < steps.length; i++) {
//     var step = steps[i];
//     var stepRect = step.getBoundingClientRect();
//     if (stepRect.top >= 0 && stepRect.top <= window.innerHeight) {
//       activeStepIndex = i;
//       break;
//     }
//   }

//   for (var j = 0; j < etapes.length; j++) {
//     var etape = etapes[j];
//     if (j === activeStepIndex) {
//       etape.classList.add('active');
//     } else {
//       etape.classList.remove('active');
//     }
//   }
// }

// document.getElementsByClassName('col steps')[0].addEventListener('scroll', setActivePart);

</script>