<?php
$landing = get_field( 'landing' );
$a_la_une = get_field( 'a_la_une' );
    $top_actu = $a_la_une['publication'];
$all_actu = get_field( 'all_actu' );

$term = get_queried_object();
?>
<div class="actu">
    <div class="landing">
        <img src="/wp-content/uploads/2023/04/filtre-blanc.png" alt="" class="filter">
        <div class="container">
            <h1 class="text-blanc"><?= $landing['title'] ?></h1>
            <p class="text-blanc"><?= $landing['text'] ?></p>
        </div>
    </div><!-- #landing -->
    <div class="a-la-une">
        <div class="container">
            <span class="mini_title">
                Castmetal Advanced Services
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2 class="title"><?= $a_la_une['title'] ?></h2>
            <?php
            global $post;
            $post                    = get_post( $top_actu, OBJECT );
            setup_postdata( $post );
            $tag = wp_get_post_terms( get_the_ID(), "category" )[0];
            ?>
            <a class="top-actu" href="<?= the_permalink() ?>">
                <div class="contain">
                    <h3 class="title"><?= the_title() ?></h3>
                    <div class="img">
                        <img src="<?= get_the_post_thumbnail_url() ?>" alt="<?= the_post_thumbnail_caption() ?>">
                    </div>
                    <div class="content">
                        <span class="tags"><?= $tag->name ?></span>
                        <p class="text-blanc"><?= get_the_excerpt() ?></p>
                        <div class="arrow">
                            <svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                viewBox="0 0 45.1 7.4" style="enable-background:new 0 0 45.1 7.4;" xml:space="preserve">
                            <style type="text/css">
                                .st0{fill:none;stroke:#FFFFFF;stroke-linecap:round;}
                            </style>
                                <g id="Groupe_138" transform="translate(0.5 0.707)">
                                    <line id="Ligne_1" class="st0" x1="0.1" y1="3" x2="43.9" y2="3"/>
                                    <line id="Ligne_2" class="st0" x1="40.9" y1="0" x2="43.9" y2="3"/>
                                    <line id="Ligne_3" class="st0" x1="40.9" y1="6" x2="43.9" y2="3"/>
                                </g>
                            </svg>
                        </div>
                        <div class="date">
                            <img src="<?= get_template_directory_uri() ?>/img/Groupe 141.svg" alt="">
                            <?= get_the_date("j F Y") ?>
                        </div>
                    </div>
                </div>
            </a>
            <?php
            wp_reset_postdata();
            ?>
        </div>
    </div><!-- #a-la-une -->
    <div class="all-actu">
        <div class="container">
            <span class="mini_title">
                <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){ ?>
                    Latest publications
                <?php } else { ?>
                    Dernières publications
                <?php } ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2 class="title"><?= $all_actu['title'] ?></h2>
            <div class="block-actu">
                <?php
                $argsTag = "";
                if ( ! empty( $term->term_id ) ) {
                    $argsTag = array(
                        'taxonomy' => 'category',
                        'terms'    => $term->slug,
                        'field'    => 'slug'
                    );
                }

                $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                    $args_query = array(
                        'post_type'      => array( 'post' ),
                        'post_status'    => array( 'publish' ),
                        'posts_per_page' => 6,
                        "s"              => $_GET['s'],
                        'paged'          => $paged,
                        'tax_query'      => array(
                            $argsTag,
                        ),
                    );

                    $query = new WP_Query( $args_query );

                    if ( $query->have_posts() ) {
                        ?>
                        <div class="content">
                            <?php
                            while ( $query->have_posts() ):
                                $query->the_post();

                                $terms = get_the_terms( get_the_ID(), 'category' );
                                ?>
                                <a href="<?= the_permalink() ?>" class="card">
                                    <div class="image">
                                        <img src="<?= get_the_post_thumbnail_url() ?>" alt="<?= the_post_thumbnail_caption() ?>">
                                        <?php
                                        $term = wp_get_post_terms( get_the_ID(), "category" )[0];
                                        ?>
                                        <div class="tag"><?= $term->name ?></div>
                                    </div>
                                    <div class="content">
                                        <h3 class="title"><?php the_title() ?></h3>
                                        <p class="author"><?= the_author_nickname() ?></p>
                                        <p class="text"><?= get_the_excerpt() ?></p>
                                        <span class="date"><?= get_the_date("d/m/Y") ?></span>
                                    </div>
                                </a>
                                <?php
                            endwhile;
                            ?>
                        </div>
                        <?php
                    }

                    wp_reset_postdata();
                ?>
                <div class="pagination">
                    <?php
                    echo paginate_links( array(
                        'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
                        'total'        => $query->max_num_pages,
                        'current'      => max( 1, get_query_var( 'paged' ) ),
                        'format'       => '?paged=%#%',
                        'show_all'     => false,
                        'type'         => 'list',
                        'end_size'     => 2,
                        'mid_size'     => 1,
                        'prev_next'    => true,
                        'prev_text'    => '<svg xmlns="http://www.w3.org/2000/svg" width="18.207" height="7.428" viewBox="0 0 18.207 7.428">
                        <g id="Groupe_148" data-name="Groupe 148" transform="translate(0.707 0.707)">
                          <line id="Ligne_1" data-name="Ligne 1" x1="17" transform="translate(0 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/>
                          <line id="Ligne_2" data-name="Ligne 2" x1="3.007" y2="3.007" transform="translate(0)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/>
                          <line id="Ligne_3" data-name="Ligne 3" x1="3.007" y1="3.007" transform="translate(0 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/>
                        </g>
                      </svg>
    ',
                        'next_text'    => '<svg xmlns="http://www.w3.org/2000/svg" width="18.207" height="7.428" viewBox="0 0 18.207 7.428">
                        <g id="Groupe_138" data-name="Groupe 138" transform="translate(0.5 0.707)">
                          <line id="Ligne_1" data-name="Ligne 1" x2="17" transform="translate(0 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/>
                          <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(13.993)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/>
                          <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(13.993 3.007)" fill="none" stroke="#0c1f40" stroke-linecap="round" stroke-width="1"/>
                        </g>
                      </svg>
    ',
                        'add_args'     => false,
                        'add_fragment' => ' ',
                    ) );
                    ?>
                </div>
            </div>
        </div>
    </div><!-- #all-actu -->
</div><!-- #actu -->