<?php
$landing = get_field( 'landing' );
$cta = get_field( 'contact' );
$faq = get_field( 'faq' );
?>
<div class="contact">
    <div class="landing">
        <img src="/wp-content/uploads/2023/04/filtre-blanc.png" alt="" class="filter">
        <div class="container">
            <h1><?= $landing['title'] ?></h1>
            <?= $landing['text'] ?>
            <div class="btn">
                <a href="<?= $landing['button']['url'] ?>"><?= $landing['button']['title'] ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18.497" height="7.428" viewBox="0 0 18.497 7.428">
                    <g id="Groupe_11" data-name="Groupe 11" transform="translate(0.5 0.707)">
                        <line id="Ligne_1" data-name="Ligne 1" x2="17.29" transform="translate(0 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_2" data-name="Ligne 2" x2="3.007" y2="3.007" transform="translate(14.283)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                        <line id="Ligne_3" data-name="Ligne 3" y1="3.007" x2="3.007" transform="translate(14.283 3.007)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1"/>
                    </g>
                    </svg>
                </a>
            </div>
        </div>
    </div>
    <div class="call-to-action">
        <div class="container">
            <div class="col">
                <div class="info">
                    <span class="title"><?= $cta['1']['title'] ?></span>
                    <?= $cta['1']['text'] ?>
                </div>
                <div class="info">
                    <span class="title"><?= $cta['2']['title'] ?></span>
                    <?= $cta['2']['text'] ?>
                    <div class="social">
                        <a href="https://www.linkedin.com/company/safemetal/">
                            <img src="/wp-content/uploads/2023/06/Icon-awesome-linkedin.svg" alt="linkedin">
                        </a>
                        <a href="https://www.youtube.com/@safemetal7026">
                            <img src="/wp-content/uploads/2023/06/Icon-awesome-youtube.svg" alt="youtube">
                        </a>
                    </div>
                </div>
            </div>  
            <div class="col">
                <div class="contact-form">
                    <!-- Contact Form 7 -->
                    <?php if (strpos($_SERVER['REQUEST_URI'], "/en". "/") !== false){
                        echo do_shortcode( '[contact-form-7 id="86e4593" title="Formulaire de contact_EN"]' );
                    } else {
                        echo do_shortcode( '[contact-form-7 id="e9ff324" title="Formulaire de contact_FR"]' );
                    } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="faq">
        <div class="container">
            <span id="ancreFAQ" class="mini_title">
                FAQ
                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="1" viewBox="0 0 39 1">
                    <line id="Ligne_6" data-name="Ligne 6" x2="39" transform="translate(0 0.5)" fill="none" stroke="#bc965c" stroke-width="1"/>
                </svg>
            </span>
            <h2 class="title"><?= $faq['title'] ?></h2>
            <?= $faq['text'] ?>
            





            <div class="question">
                
            <?php
                        
            $questions = $faq['question'];

            // Vérifier si des slides sont disponibles
            if ($questions) {
                foreach ($questions as $question) {
                // Récupérer les valeurs des sous-champs du slide
                $titre = $question['titre'];
                $reponse = $question['reponse'];
                ?>
                              
                <div class="answer">
                    <div class="arrow">
                        <svg xmlns="http://www.w3.org/2000/svg" width="13.992" height="8" viewBox="0 0 13.992 8">
                            <path id="Icon_ionic-ios-arrow-down" data-name="Icon ionic-ios-arrow-down" d="M13.186,16.835l5.291-5.295a1,1,0,0,1,1.412,0,1.008,1.008,0,0,1,0,1.416l-5.995,6a1,1,0,0,1-1.379.029L6.479,12.961a1,1,0,1,1,1.412-1.416Z" transform="translate(20.179 19.246) rotate(180)" fill="#bc965c"/>
                        </svg>
                    </div>
                    <h3 class="title"><?=  $titre ?></h3>
                    <p class="text"><?= $reponse?></p>
                </div>
                <?php
                                }
                            }
                            ?>
            </div>
        </div>
    </div>
</div>
<script>
// Récupérer tous les éléments avec la classe "answer"
var answers = document.querySelectorAll('.answer');

// Parcourir chaque élément et ajouter un écouteur d'événement pour le clic
answers.forEach(function(answer) {
  answer.addEventListener('click', function() {
    // Vérifier si la div cliquée a déjà la classe "show"
    var isActive = answer.classList.contains('show');

    // Supprimer la classe "show" de toutes les divs
    answers.forEach(function(answer) {
      answer.classList.remove('show');
    });

    // Ajouter la classe "show" uniquement à la div cliquée si elle n'est pas déjà active
    if (!isActive) {
      answer.classList.add('show');
    }
  });
});
</script>

